<?php
require "../config.php";
require "../includes/auth.php";

if ($_POST) {
    $stmt = $pdo->prepare("INSERT INTO courses(name,description,price,course_url,payment_qr) 
                           VALUES(?,?,?,?,?)");
    $stmt->execute([
        $_POST['name'],
        $_POST['desc'],
        $_POST['price'],
        $_POST['url'],
        $_POST['qr']
    ]);
    header("Location: courses.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New Course</title>

    <!-- Bootstrap 5.3 + Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        :root {
            --bg-dark: #0d1117;
            --card-bg: #161b22;
            --border-color: #30363d;
            --text-muted: #8b949e;
            --success-glow: #238636;
        }

        body {
            background: var(--bg-dark);
            color: #c9d1d9;
            min-height: 100vh;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }

        .page-header {
            border-bottom: 1px solid var(--border-color);
            padding-bottom: 1rem;
            margin-bottom: 2rem;
        }

        .form-card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 16px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
            overflow: hidden;
        }

        .form-header {
            background: linear-gradient(135deg, #21262d, #161b22);
            padding: 1.5rem;
            border-bottom: 1px solid var(--border-color);
        }

        .form-body {
            padding: 2rem;
        }

        .form-control, .form-control:focus {
            background: #0d1117;
            border: 1px solid #30363d;
            color: #fff;
            border-radius: 10px;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: #58a6ff;
            box-shadow: 0 0 0 3px rgba(88, 166, 255, 0.2);
            background: #0d1117;
        }

        .form-label {
            color: #58a6ff;
            font-weight: 600;
            font-size: 0.95rem;
            margin-bottom: 0.5rem;
        }

        textarea.form-control {
            min-height: 120px;
            resize: vertical;
        }

        .btn-save {
            background: #238636;
            border: none;
            padding: 0.75rem 2rem;
            font-weight: 600;
            border-radius: 10px;
            transition: all 0.3s ease;
        }

        .btn-save:hover {
            background: #2ea043;
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(35, 134, 54, 0.4);
        }

        .btn-back {
            border-radius: 10px;
            padding: 0.75rem 1.5rem;
        }

        @media (max-width: 576px) {
            .form-body {
                padding: 1.5rem;
            }
            .btn-save, .btn-back {
                width: 100%;
            }
        }
    </style>
</head>
<body class="pb-5">

<div class="container py-5">
    <!-- Back Button & Title -->
    <div class="d-flex align-items-center mb-4 gap-3 flex-wrap">
        <a href="courses.php" class="btn btn-outline-secondary btn-back">
            <i class="bi bi-arrow-left"></i> Back to Courses
        </a>
        <h2 class="mb-0 text-white">
            <i class="bi bi-plus-circle-dotted text-success"></i> Add New Course
        </h2>
    </div>

    <!-- Success Message (optional - you can show after redirect if needed) -->
    <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle-fill"></i> Course added successfully!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Form Card -->
    <div class="row justify-content-center">
        <div class="col-lg-8 col-xl-7">
            <div class="form-card">
                <div class="form-header text-center">
                    <h4 class="mb-0 text-white">
                        <i class="bi bi-book-fill text-primary"></i> Course Details
                    </h4>
                    <small class="text-muted">Fill in all required fields to create a new course</small>
                </div>

                <div class="form-body">
                    <form method="post">
                        <div class="mb-4">
                            <label class="form-label">
                                <i class="bi bi-card-heading"></i> Course Name <span class="text-danger">*</span>
                            </label>
                            <input type="text" name="name" class="form-control form-control-lg" 
                                   placeholder="e.g., Full Stack Web Development" required>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">
                                <i class="bi bi-chat-square-text"></i> Description
                            </label>
                            <textarea name="desc" class="form-control" rows="4"
                                      placeholder="Brief description about the course (optional but recommended)"></textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label">
                                    <i class="bi bi-currency-rupee"></i> Price (₹) <span class="text-danger">*</span>
                                </label>
                                <input type="number" name="price" class="form-control form-control-lg" 
                                       placeholder="2999" min="0" step="1" required>
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="form-label">
                                    <i class="bi bi-link-45deg"></i> Course Access Link
                                </label>
                                <input type="url" name="url" class="form-control form-control-lg" 
                                       placeholder="https://yourcourse.com/access/xyz">
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">
                                <i class="bi bi-qr-code-scan"></i> Payment QR Code Image URL
                            </label>
                            <input type="url" name="qr" class="form-control form-control-lg" 
                                   placeholder="https://i.imgur.com/abc123.jpg">
                            <div class="form-text">
                                Upload QR to <a href="https://imgur.com" target="_blank" class="text-info">imgur.com</a> or similar and paste direct link
                            </div>
                        </div>

                        <div class="d-grid d-md-flex justify-content-end gap-3 mt-5">
                            <a href="courses.php" class="btn btn-outline-light btn-back order-md-1">
                                Cancel
                            </a>
                            <button type="submit" class="btn btn-success btn-save order-md-2">
                                <i class="bi bi-check2-all"></i> Save Course
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>