<?php
session_start();
require "../config.php";
// Admin login check
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}
// Fetch all institutes
$institutes = $pdo->query("SELECT * FROM institutes ORDER BY name ASC")->fetchAll();
// Selected institute & branch
$current_inst = intval($_GET['inst'] ?? 0);
$current_branch = intval($_GET['branch'] ?? 0);
// Fetch branches of selected institute
$branches = [];
if ($current_inst > 0) {
    $stmt = $pdo->prepare("SELECT * FROM branches WHERE institute_id=? ORDER BY name ASC");
    $stmt->execute([$current_inst]);
    $branches = $stmt->fetchAll();
}
// Fetch courses for selected branch
$courses = [];
if ($current_branch > 0) {
    $stmt = $pdo->prepare("SELECT * FROM courses WHERE branch_id=? ORDER BY id DESC");
    $stmt->execute([$current_branch]);
    $courses = $stmt->fetchAll();
}
/* ------------------------------------------
            ADD COURSE
------------------------------------------- */
if (isset($_POST['add'])) {
    $inst = intval($_POST['inst']);
    $branch = intval($_POST['branch']);
    $name = trim($_POST['name']);
    $desc = trim($_POST['description']);
    $price = floatval($_POST['price']);
    $group_link = trim($_POST['group_link']);
    // QR upload handling
    $qr_path = "";
    if (!empty($_FILES['qr']['name'])) {
        $qr_path = "uploads/qr_" . time() . "_" . basename($_FILES['qr']['name']);
        move_uploaded_file($_FILES['qr']['tmp_name'], "../" . $qr_path);
    }
    if ($inst > 0 && $branch > 0 && $name != "") {
        $stmt = $pdo->prepare("
            INSERT INTO courses (institute_id, branch_id, name, description, price, payment_qr, group_link)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([$inst, $branch, $name, $desc, $price, $qr_path, $group_link]);
        header("Location: manage_courses.php?inst=$inst&branch=$branch");
        exit;
    }
}
/* ------------------------------------------
            DELETE COURSE
------------------------------------------- */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $find = $pdo->prepare("SELECT institute_id, branch_id FROM courses WHERE id=?");
    $find->execute([$id]);
    $f = $find->fetch();
    if ($f) {
        $pdo->prepare("DELETE FROM courses WHERE id=?")->execute([$id]);
        header("Location: manage_courses.php?inst={$f['institute_id']}&branch={$f['branch_id']}");
        exit;
    }
}
/* ------------------------------------------
            UPDATE COURSE
------------------------------------------- */
if (isset($_POST['update'])) {
    $id = intval($_POST['id']);
    $inst = intval($_POST['inst']);
    $branch = intval($_POST['branch']);
    $name = trim($_POST['name']);
    $desc = trim($_POST['description']);
    $price = floatval($_POST['price']);
    $group_link = trim($_POST['group_link']);
    // QR upload check
    if (!empty($_FILES['qr']['name'])) {
        $qr_path = "uploads/qr_" . time() . "_" . basename($_FILES['qr']['name']);
        move_uploaded_file($_FILES['qr']['tmp_name'], "../" . $qr_path);
        $pdo->prepare("UPDATE courses SET payment_qr=? WHERE id=?")->execute([$qr_path, $id]);
    }
    $pdo->prepare("
        UPDATE courses
        SET name=?, description=?, price=?, group_link=?, institute_id=?, branch_id=?
        WHERE id=?
    ")->execute([$name, $desc, $price, $group_link, $inst, $branch, $id]);
    header("Location: manage_courses.php?inst=$inst&branch=$branch");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Courses</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- UPDATED STYLES FOR VISIBILITY -->
    <style>
        :root {
            --bg-dark: #0d1117;
            --card-bg: #161b22;
            --border-color: #30363d;
            --text-muted: #c5ced8;
            --text-main: #ffffff;
        }
        body { 
            background: var(--bg-dark); 
            color: var(--text-main); 
            min-height: 100vh; 
            font-family: -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;
        }
        .card-custom { 
            background: var(--card-bg); 
            border: 1px solid var(--border-color); 
            border-radius: 16px; 
            color: var(--text-main);
        }
        .form-control, .form-select { 
            background: #121820; 
            border: 1px solid var(--border-color); 
            color: var(--text-main); 
            border-radius: 10px; 
        }
        .form-control:focus, .form-select:focus { 
            border-color: #58a6ff; 
            box-shadow: 0 0 0 3px rgba(88,166,255,0.3); 
            background: #0d1117; 
            color: var(--text-main); 
        }
        label { color: #e6edf3; font-weight: 500; }

        .table {
            --bs-table-bg: transparent;
            --bs-table-border-color: var(--border-color);
            color: var(--text-main);
        }
        .table th {
            background: #1f2731 !important;
            color: #fff;
        }
        .table td {
            color: #e6edf3 !important;
        }

        .modal-content {
            background: #161b22 !important;
            color: white;
        }

        .btn-outline-primary, .btn-outline-danger {
            color: white !important;
        }
        .btn-outline-primary:hover {
            background: #0d6efd;
        }
        .btn-outline-danger:hover {
            background: #dc3545;
        }

        a { color: #58a6ff; }
        a:hover { color: #79c0ff; }

    </style>
</head>

<body class="pb-5">
<div class="container py-5">

    <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-3">
        <h2 class="mb-0"><i class="bi bi-journal-text text-primary"></i> Manage Courses</h2>
        <a href="dashboard.php" class="btn btn-outline-secondary"><i class="bi bi-speedometer2"></i> Dashboard</a>
    </div>

    <!-- Institute Selector -->
    <div class="card-custom p-4 mb-4">
        <form method="GET" class="row g-3 align-items-end">
            <div class="col-md-5">
                <label class="form-label text-info"><i class="bi bi-building"></i> Select Institute</label>
                <select name="inst" class="form-select form-select-lg" onchange="this.form.submit()">
                    <option value="">-- Choose Institute --</option>
                    <?php foreach ($institutes as $i): ?>
                        <option value="<?= $i['id'] ?>" <?= ($current_inst == $i['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($i['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </form>
    </div>

    <?php if ($current_inst): ?>
    <!-- Branch Selector -->
    <div class="card-custom p-4 mb-4">
        <form method="GET" class="row g-3 align-items-end">
            <input type="hidden" name="inst" value="<?= $current_inst ?>">
            <div class="col-md-5">
                <label class="form-label text-info"><i class="bi bi-geo-alt"></i> Select Branch</label>
                <select name="branch" class="form-select form-select-lg" onchange="this.form.submit()">
                    <option value="">-- Choose Branch --</option>
                    <?php foreach ($branches as $b): ?>
                        <option value="<?= $b['id'] ?>" <?= ($current_branch == $b['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($b['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </form>
    </div>
    <?php endif; ?>

    <?php if ($current_branch): ?>
    <!-- Add New Course -->
    <div class="card-custom p-4 mb-5">
        <h4 class="mb-4 text-success"><i class="bi bi-plus-circle"></i> Add New Course</h4>
        <form method="POST" enctype="multipart/form-data">
            <input type="hidden" name="inst" value="<?= $current_inst ?>">
            <input type="hidden" name="branch" value="<?= $current_branch ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Course Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" class="form-control" required placeholder="Full Stack Web Development">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Price (₹) <span class="text-danger">*</span></label>
                    <input type="number" name="price" class="form-control" required placeholder="2999" min="0">
                </div>
                <div class="col-12">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="3" placeholder="Brief description..."></textarea>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Telegram Group Link</label>
                    <input type="url" name="group_link" class="form-control" placeholder="https://t.me/yourgroup">
                </div>
                
                <div class="col-12">
                    <button type="submit" name="add" class="btn btn-success btn-lg">
                        <i class="bi bi-plus-circle"></i> Add Course
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Table -->
    <div class="card-custom overflow-hidden">
        <div class="card-header bg-dark border-bottom border-secondary">
            <h5 class="mb-0 text-white"><i class="bi bi-list-ul"></i> Existing Courses (<?= count($courses) ?>)</h5>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Course Name</th>
                        <th>Description</th>
                        <th>Price</th>
                        <th>Group Link</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($courses as $c): ?>
                    <tr>
                        <td><?= $c['id'] ?></td>
                        <td><strong><?= htmlspecialchars($c['name']) ?></strong></td>
                        <td><?= htmlspecialchars(substr($c['description'], 0, 80)) ?><?= strlen($c['description']) > 80 ? '...' : '' ?></td>
                        <td>₹<?= number_format($c['price']) ?></td>
                        <td>
                            <a href="<?= htmlspecialchars($c['group_link']) ?>" target="_blank" class="text-info">
                                <i class="bi bi-box-arrow-up-right"></i> Open
                            </a>
                        </td>
                        
                        <td>
                            <button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal"
                                    onclick="fillEditModal(
                                        <?= $c['id'] ?>, 
                                        <?= $current_inst ?>, 
                                        <?= $current_branch ?>,
                                        `<?= htmlspecialchars($c['name'], ENT_QUOTES) ?>`,
                                        `<?= htmlspecialchars($c['description'], ENT_QUOTES) ?>`,
                                        <?= $c['price'] ?>,
                                        `<?= htmlspecialchars($c['group_link'], ENT_QUOTES) ?>`
                                    )">
                                <i class="bi bi-pencil"></i> Edit
                            </button>
                            <a href="?delete=<?= $c['id'] ?>" class="btn btn-outline-danger btn-sm"
                               onclick="return confirm('Delete this course permanently?')">
                                <i class="bi bi-trash"></i> Delete
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content bg-dark text-white">
            <div class="modal-header border-secondary">
                <h5 class="modal-title"><i class="bi bi-pencil-square"></i> Edit Course</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <input type="hidden" name="inst" id="edit_inst">
                    <input type="hidden" name="branch" id="edit_branch">

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Course Name</label>
                            <input type="text" name="name" id="edit_name" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Price (₹)</label>
                            <input type="number" name="price" id="edit_price" class="form-control" required>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Description</label>
                            <textarea name="description" id="edit_desc" class="form-control" rows="3" required></textarea>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label">Telegram Group Link</label>
                            <input type="url" name="group_link" id="edit_group" class="form-control">
                        </div>
                        
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="update" class="btn btn-success">
                        <i class="bi bi-check2-all"></i> Update Course
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function fillEditModal(id, inst, branch, name, desc, price, group) {
    document.getElementById('edit_id').value = id;
    document.getElementById('edit_inst').value = inst;
    document.getElementById('edit_branch').value = branch;
    document.getElementById('edit_name').value = name;
    document.getElementById('edit_desc').value = desc;
    document.getElementById('edit_price').value = price;
    document.getElementById('edit_group').value = group;
}
</script>

</body>
</html>
