<?php
session_start();
require "../config.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// Filter
$status = $_GET['status'] ?? "";

// Fetch orders
$query = "
    SELECT o.*, u.telegram_id, u.first_name, c.name AS course_name 
    FROM orders o
    JOIN users u ON o.user_id = u.id
    JOIN courses c ON o.course_id = c.id
";

$params = [];

if ($status != "") {
    $query .= " WHERE o.status = ? ";
    $params[] = $status;
}

$query .= " ORDER BY o.id DESC";

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$orders = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Orders</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <style>

    body {
        background: #0d1117; /* dark background */
        margin: 0;
        font-family: Arial, sans-serif;
        color: #fff;
    }

    /* FIX THE MAIN CONTAINER */
    .main-container {
        width: 100%;
        max-width: 1500px;
        margin: auto;
        padding: 20px;
        background: #0d1117;
    }

    /* FIX TABLE BACKGROUND */
    table {
        width: 100%;
        background: #161b22; /* DARK background */
        border-collapse: collapse;
    }

    th {
        background: #222;
        color: #fff;
        padding: 12px;
        border-bottom: 1px solid #444;
        text-align: left;
    }

    td {
        padding: 12px;
        border-bottom: 1px solid #333;
        color: #e0e0e0; /* BRIGHT text */
    }

    tr:hover {
        background: #1f2933;
    }

    /* STATUS COLORS */
    .pending {
        background: #b37d00;
        color: #fff;
        padding: 6px 12px;
        border-radius: 5px;
    }
    .review {
        background: #0066cc;
        color: #fff;
        padding: 6px 12px;
        border-radius: 5px;
    }
    .approved {
        background: #0a8a32;
        color: #fff;
        padding: 6px 12px;
        border-radius: 5px;
    }

    img.screenshot {
        width: 120px;
        border-radius: 6px;
        border: 1px solid #444;
    }

    .btn-approve {
        padding: 7px 14px;
        background: #0a8a32;
        color: white;
        border: none;
        border-radius: 6px;
        cursor: pointer;
    }
    .btn-approve:hover {
        background: #0dbf45;
    }

</style>

</head>

<body>

<div class="container-xl">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold">
            <i class="bi bi-receipt"></i> Manage Orders
        </h2>
        <a href="dashboard.php" class="btn btn-outline-light">
            <i class="bi bi-speedometer"></i> Dashboard
        </a>
    </div>

    <!-- Filter Card -->
    <div class="card-custom mb-4">
        <h5><i class="bi bi-funnel"></i> Filter Orders</h5>
        <form method="GET" class="mt-3">
            <select name="status" class="form-select w-auto" onchange="this.form.submit()">
                <option value="">All Orders</option>
                <option value="pending" <?= ($status=="pending")?"selected":"" ?>>Pending</option>
                <option value="review" <?= ($status=="review")?"selected":"" ?>>Under Review</option>
                <option value="approved" <?= ($status=="approved")?"selected":"" ?>>Approved</option>
            </select>
        </form>
    </div>

    <!-- Orders Table -->
    <div class="card-custom">
        <h5 class="fw-bold mb-3">
            <i class="bi bi-list-check"></i> Orders (<?= count($orders) ?>)
        </h5>

        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Course</th>
                        <th>Status</th>
                        <th>Screenshot</th>
                        <th>UTR</th>
                        <th class="text-end">Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($orders as $o): ?>
                    <tr>
                        <td><?= $o['id'] ?></td>

                        <td>
                            <strong><?= htmlspecialchars($o['first_name']) ?></strong><br>
                            <small>Telegram: <?= $o['telegram_id'] ?></small>
                        </td>

                        <td><?= htmlspecialchars($o['course_name']) ?></td>

                        <td>
                            <span class="<?= $o['status'] ?>">
                                <?= ucfirst($o['status']) ?>
                            </span>
                        </td>

                        <td>
                            <?php if ($o['payment_screenshot']): ?>
                                <a href="<?= $o['payment_screenshot'] ?>" target="_blank">
                                    <img src="<?= $o['payment_screenshot'] ?>" class="screenshot">
                                </a>
                            <?php else: ?>
                                <span>No Screenshot</span>
                            <?php endif; ?>
                        </td>

                        <td><?= $o['utr'] ?: "" ?></td>

                        <td class="text-end">
                            <?php if ($o['status'] != "approved"): ?>
                                <a href="approve.php?id=<?= $o['id'] ?>">
                                    <button class="btn-approve">
                                        <i class="bi bi-check2-circle"></i> Approve
                                    </button>
                                </a>
                            <?php else: ?>
                                <span class="text-success fw-bold">
                                    <i class="bi bi-check2-circle"></i> Approved
                                </span>
                            <?php endif; ?>
                        </td>

                    </tr>
                <?php endforeach; ?>
                </tbody>

            </table>
        </div>
    </div>

</div>

</body>
</html>
